//* This program will read a rotary encoder connected to pins rb6 and rb7.

#include<16F877.H>							//Using the PIC 16F877
#device adc=10;								//Set ADC to 10 bit
#fuses HS,NOWDT,NOPROTECT,NOBROWNOUT,NOPUT	//Configuration Fuses
#use delay(clock=20000000)					//20Mhz Clock
#use rs232(baud=9600,xmit=PIN_c6,rcv=PIN_C7,PARITY=N,BITS=8)//Use RS-232
#org 0x1F00,0x1FFF{}                        //Reserve Memory for Bootloader

extern int1 A1_current_state;
extern int1 B1_current_state;
extern int1 A1_last_state;
extern int1 B1_last_state;
extern signed int16 current_position;


#int_rb
void rb_isr() {
A1_last_state = A1_current_state;
B1_last_state = B1_current_state;
A1_current_state = input(pin_b7);
B1_current_state = input(pin_b6);
if (A1_current_state ^ B1_last_state)
	current_position = --current_position;
else current_position = ++current_position;
}

//***		Main Program	***//
void main() {
PORT_B_PULLUPS(True);
enable_interrupts(int_rb);
enable_interrupts(global);

puts("PIC16F877 - Up And Running @ 20 MHz\r\n"); //send OK message to serial port

A1_current_state = input(pin_b7);
B1_current_state = input(pin_b6);
current_position = 0;

//***	Main Loop	***//

while(true){
	printf("Current Position = %5LD \r",current_position);	//Send position to serial port
	delay_ms(100);
	}
}